# 帳票設計書 19-Cluster Manager Report

## 概要

本ドキュメントは、OpenSearchのCat API「/_cat/cluster_manager」エンドポイントが出力するCluster Manager Reportの設計仕様を定義する。本帳票は現在のクラスタマネージャ（旧称master）ノードの情報をテキストテーブル形式にて出力するものである。

### 本帳票の処理概要

本帳票は、OpenSearchクラスタの現在のクラスタマネージャノードの基本情報（ID、ホスト名、IPアドレス、ノード名）を表示する。出力は常に1行のみで、クラスタマネージャが選出されていない場合は全カラムが「-」で出力される。

**業務上の目的・背景**：クラスタマネージャはクラスタの状態管理を行う最重要ノードであり、どのノードが現在クラスタマネージャであるかを把握することはクラスタ運用の基本である。クラスタマネージャの切り替わりやフェイルオーバーの確認に本帳票が活用される。

**帳票の利用シーン**：現在のクラスタマネージャノードの確認、クラスタマネージャフェイルオーバー後の状態確認、クラスタ構成の基本情報取得に利用される。

**主要な出力内容**：
1. クラスタマネージャノードのID
2. ホスト名
3. IPアドレス
4. ノード名

**帳票の出力タイミング**：ユーザーがREST APIエンドポイント `GET /_cat/cluster_manager` にHTTPリクエストを送信した際にリアルタイムで生成・出力される。旧エンドポイント `GET /_cat/master` も互換性のため利用可能。

**帳票の利用者**：OpenSearchクラスタ管理者、運用監視担当者。

## 帳票種別

一覧表（クラスタマネージャ情報、常に1行）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | REST API | `GET /_cat/cluster_manager` | HTTPリクエスト送信 |
| - | REST API（非推奨） | `GET /_cat/master` | HTTPリクエスト送信（非推奨パス） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | text/plain（テキストテーブル）またはJSON/YAML（format指定時） |
| 用紙サイズ | N/A（API応答） |
| 向き | N/A |
| ファイル名 | N/A（HTTPレスポンスボディ） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

テキストテーブル形式で、常に1行のみ出力される最もシンプルな帳票の一つ。

```
┌──────────────────────────────────────┐
│  ヘッダー部（id, host, ip, node）     │
├──────────────────────────────────────┤
│  明細部（常に1行）                    │
│  例: abc123  host1  10.0.0.1  node1  │
│  または: -  -  -  -（未選出時）       │
└──────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | id | クラスタマネージャノードID | DiscoveryNode.getId() | 文字列 |
| 2 | host | ホスト名 | DiscoveryNode.getHostName() | 文字列（alias: h） |
| 3 | ip | IPアドレス | DiscoveryNode.getHostAddress() | 文字列 |
| 4 | node | ノード名 | DiscoveryNode.getName() | 文字列（alias: n） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | id | ノードID | DiscoveryNode.getId() / "-" | 文字列 | 可変 |
| 2 | host | ホスト名 | DiscoveryNode.getHostName() / "-" | 文字列 | 可変 |
| 3 | ip | IPアドレス | DiscoveryNode.getHostAddress() / "-" | 文字列 | 可変 |
| 4 | node | ノード名 | DiscoveryNode.getName() / "-" | 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| local | ローカルノードのクラスタステートのみ参照するか | No（デフォルト: false） |
| cluster_manager_timeout | タイムアウト | No |

### ソート順

ソートなし（常に1行）。

### 改ページ条件

改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ClusterState.nodes（内部API） | クラスタマネージャノード取得 | ClusterStateRequest.clear().nodes(true) |

### テーブル別参照項目詳細

#### ClusterStateResponse

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| DiscoveryNodes.getClusterManagerNodeId() | - | - | マネージャノードIDの取得 |
| DiscoveryNodes.get(clusterManagerNodeId) | id, host, ip, node | nullの場合"-"出力 | マネージャノードオブジェクト |

## 計算仕様

### 計算項目一覧

本帳票に計算項目は存在しない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[クライアントからGETリクエスト受信] --> B[RestClusterManagerAction.doCatRequest]
    B --> C[ClusterStateRequest生成 - nodes=true]
    C --> D[NodeClient.admin.cluster.state実行]
    D --> E[ClusterStateResponse受信]
    E --> F[buildTable: getClusterManagerNodeId取得]
    F --> G{clusterManagerノード存在?}
    G -->|Yes| H[ノード情報をテーブルに追加]
    G -->|No| I[全カラムを"-"で追加]
    H --> J[RestTable.buildResponse]
    I --> J
    J --> K[HTTPレスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| マネージャ未選出 | クラスタマネージャが選出されていない場合 | 全カラム"-"（行118-121） | 正常なフォールバック表示 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 常に1行 |
| 目標出力時間 | 通常1秒以内 |
| 同時出力数上限 | REST APIスレッドプールに依存 |

## セキュリティ考慮事項

クラスタマネージャ情報はクラスタの基本構成情報であるため、cluster:monitor/state 権限を持つユーザーのみアクセス可能とすべきである。

## 備考

- canTripCircuitBreaker()がfalseをオーバーライド（行95-97）。この帳票はサーキットブレーカーをトリップしない
- `/_cat/master` は `/_cat/cluster_manager` への非推奨パス。ReplacedRouteで定義（行63）
- `master_timeout` パラメータは非推奨
- 最もシンプルなCat API帳票の一つ（常に1行出力）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiscoveryNodes.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNodes.java` | getClusterManagerNodeId()メソッド |
| 1-2 | DiscoveryNode.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` | getId(), getHostName(), getHostAddress(), getName() |

**読解のコツ**: DiscoveryNodes.get(id)がnullを返す場合はクラスタマネージャ未選出状態。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterManagerAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` | 帳票メインクラス。132行 |

**主要処理フロー**:
1. **行61-64**: replacedRoutes()で新旧パスを定義（`/_cat/cluster_manager` と非推奨 `/_cat/master`）
2. **行77-92**: doCatRequest()でClusterStateRequest（nodes=true）を発行
3. **行95-97**: canTripCircuitBreaker()をfalseでオーバーライド
4. **行100-108**: getTableWithHeader()で4カラム定義
5. **行111-131**: buildTable()でマネージャノード情報を取得。null時は"-"出力

### プログラム呼び出し階層図

```
HTTP GET /_cat/cluster_manager (or /_cat/master)
    |
    +-- AbstractCatAction.prepareRequest()
        |
        +-- RestClusterManagerAction.doCatRequest() [行77]
            |
            +-- ClusterStateRequest.clear().nodes(true) [行78-79]
            +-- NodeClient.admin().cluster().state() [行86]
                |
                +-- RestResponseListener.buildResponse() [行88]
                    |
                    +-- buildTable() [行111]
                    |   +-- nodes.getClusterManagerNodeId() [行116]
                    |   +-- nodes.get(clusterManagerNodeId) [行116]
                    |   +-- if null: "-" x 4 [行118-121]
                    |   +-- else: node info x 4 [行123-126]
                    |
                    +-- RestTable.buildResponse() [行89]
```

### データフロー図

```
[入力]                       [処理]                           [出力]

HTTP GET Request      --> RestClusterManagerAction        --> HTTP Response
  /_cat/cluster_manager    |                                  (text/plain
                           +-> ClusterStateRequest             or JSON)
                           |   (nodes only)
                           +-> ClusterStateResponse
                           |   (DiscoveryNodes)
                           +-> getClusterManagerNodeId()
                           +-> nodes.get(id)
                           |   (null check)
                           +-> buildTable() (1 row)
                           +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterManagerAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` | ソース | 帳票メインクラス（132行） |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| RestTable.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` | ソース | テーブルレスポンス構築 |
| DiscoveryNodes.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNodes.java` | ソース | クラスタノード管理 |
| DiscoveryNode.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` | ソース | ノード情報 |
| ClusterStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateRequest.java` | ソース | クラスタステートリクエスト |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション登録 |
